/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl.stream;

import com.ibm.hwmca.fw.fcs.FcsConnection;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsService;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.fcs.chatlet.Chatlet;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletRequest;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletResponse;
import com.ibm.hwmca.fw.fcs.chatlet.ChatletServerPortal;
import com.ibm.hwmca.fw.fcs.impl.FcsConnectionManager;
import com.ibm.hwmca.fw.fcs.impl.stream.StreamConstants;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FcsControlService
implements FcsService,
StreamConstants,
Chatlet {
    private static final String TRACE_MASKD = "XFCSFCSD";
    private static final String TRACE_MASKF = "XFCSFCSF";
    private static final String TRACE_MASKT = "XFCSFCST";
    private ChatletServerPortal portal;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void processConnection(FcsConnection connection) {
        block12: {
            connection.getSocket().setSoTimeout(120000);
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(connection.getSocket().getInputStream()));
            Map inMap = (Map)ois.readObject();
            Map outMap = this.buildResponse(inMap);
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(connection.getSocket().getOutputStream()));
            oos.flush();
            oos.writeObject(outMap);
            oos.flush();
            Object var7_7 = null;
            try {
                if (connection != null && connection.getSocket() != null) {
                    connection.getSocket().close();
                }
                break block12;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "caught expected exception closing socket: " + e.getMessage());
            }
            break block12;
            {
                catch (Throwable t) {
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    this.handleError(t);
                    Object var7_8 = null;
                    try {
                        if (connection != null && connection.getSocket() != null) {
                            connection.getSocket().close();
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        Trace.trace(TRACE_MASKF, "caught expected exception closing socket: " + e.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    if (connection != null && connection.getSocket() != null) {
                        connection.getSocket().close();
                    }
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "caught expected exception closing socket: " + e.getMessage());
                }
                throw throwable;
            }
        }
    }

    private Map buildResponse(Map inMap) {
        this.examineRemoteData(inMap);
        String command = (String)inMap.get("FcsControlCommand");
        if (command == null) {
            command = "";
        }
        if (command.equals("FcsControlCommandPing")) {
            return this.handlePing(inMap);
        }
        if (command.equals("FcsControlCommandDataExchange")) {
            return this.handleDataExchange(inMap);
        }
        if (command.equals("FcsControlCommandHorizon")) {
            return this.handleHorizonSearch(inMap);
        }
        Trace.trace(TRACE_MASKF, "I didn't understand command: " + command);
        return new HashMap();
    }

    private void examineRemoteData(Map inMap) {
        if (inMap.containsKey("otherMachineServices")) {
            Trace.trace(TRACE_MASKF, "We received info about other machines");
            Map servicesMap = (Map)inMap.get("otherMachineServices");
            Map bootTimesMap = (Map)inMap.get("otherMachineBootTimes");
            Map handshakeTimesMap = (Map)inMap.get("otherMachineHandshakeTimes");
            FcsServer fcsServer = FcsServer.getFcsServer();
            Iterator iterator = servicesMap.keySet().iterator();
            while (iterator.hasNext()) {
                MachineId tmpId = (MachineId)iterator.next();
                Set serviceList = (Set)servicesMap.get(tmpId);
                Date bootTime = (Date)bootTimesMap.get(tmpId);
                long handshakeTime = (Long)handshakeTimesMap.get(tmpId);
                if (!fcsServer.getRemoteServiceList(tmpId).isEmpty()) {
                    long ourHandshakeTime = FcsConnectionManager.timeSinceLastHandshake(tmpId);
                    if (handshakeTime < ourHandshakeTime) {
                        Trace.trace(TRACE_MASKF, "their info is newer");
                        fcsServer.addRemoteServiceList(tmpId, serviceList, bootTime);
                        FcsConnectionManager.didHandshake(tmpId, System.currentTimeMillis() - handshakeTime);
                        continue;
                    }
                    Trace.trace(TRACE_MASKF, "Our info is newer");
                    continue;
                }
                Trace.trace(TRACE_MASKF, "Don't know anything about: " + tmpId);
                Trace.trace(TRACE_MASKF, "not updating");
            }
        } else {
            Trace.trace(TRACE_MASKF, "We did not receive info about other machines");
        }
    }

    private void addRemoteData(Map map) {
        HashMap<MachineId, Set> servicesMap = new HashMap<MachineId, Set>();
        HashMap<MachineId, Date> bootTimesMap = new HashMap<MachineId, Date>();
        HashMap<MachineId, Long> handshakeTimesMap = new HashMap<MachineId, Long>();
        FcsServer fcsServer = FcsServer.getFcsServer();
        Set machineList = fcsServer.getMachineList();
        Iterator iterator = machineList.iterator();
        while (iterator.hasNext()) {
            MachineId tmpId = (MachineId)iterator.next();
            Set tmpServiceList = fcsServer.getRemoteServiceList(tmpId);
            Date tmpBootTime = fcsServer.getBootTime(tmpId);
            if (tmpServiceList == null || tmpServiceList.isEmpty() || tmpBootTime == null) continue;
            servicesMap.put(tmpId, tmpServiceList);
            bootTimesMap.put(tmpId, tmpBootTime);
            handshakeTimesMap.put(tmpId, new Long(FcsConnectionManager.timeSinceLastHandshake(tmpId)));
        }
        map.put("otherMachineServices", servicesMap);
        map.put("otherMachineBootTimes", bootTimesMap);
        map.put("otherMachineHandshakeTimes", handshakeTimesMap);
    }

    private Map handlePing(Map inMap) {
        Trace.trace(TRACE_MASKT, "FcsControlService.handlePing()");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("FcsControlCommand", "FcsControlCommandPong");
        return map;
    }

    private Map handleDataExchange(Map inMap) {
        Trace.trace(TRACE_MASKT, "<> FcsControlService.handleDataExchange()");
        MachineId machineId = (MachineId)inMap.get("FcsControlMachineId");
        Set services = (Set)inMap.get("FcsControlServices");
        Date bootTime = (Date)inMap.get("FcsControlBootTime");
        if (machineId != null && services != null && bootTime != null) {
            FcsServer.getFcsServer().addRemoteServiceList(machineId, services, bootTime);
            FcsConnectionManager.didHandshake(machineId);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FcsControlCommand", "FcsControlCommandDataExchange");
        map.put("FcsControlMachineId", FcsServer.getFcsServer().getLocalMachineId());
        map.put("FcsControlServices", FcsServer.getFcsServer().getLocalServices());
        map.put("FcsControlBootTime", FcsServer.getFcsServer().getLocalBootTime());
        this.addRemoteData(map);
        return map;
    }

    private Map handleHorizonSearch(Map inMap) {
        Trace.trace(TRACE_MASKT, "<> FcsControlService.handleHorizonSearch() [deprecated]");
        Set otherMachines = (Set)inMap.get("FcsControlCommandHorizon");
        HashSet<MachineId> currentList = new HashSet<MachineId>();
        currentList.add(FcsServer.getFcsServer().getLocalMachineId());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FcsControlCommand", "FcsControlCommandHorizon");
        map.put("FcsControlCommandHorizon", currentList);
        return map;
    }

    private void handleError(Throwable t) {
    }

    private byte[] mapToBytes(Map map) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(map);
            oos.flush();
            return baos.toByteArray();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception in mapToBytes()");
            return new byte[0];
        }
    }

    private Map bytesToMap(byte[] bytes) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object o = ois.readObject();
            return (Map)o;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception in bytesToMap()");
            return new HashMap();
        }
    }

    public ChatletResponse request(ChatletRequest request) {
        Trace.trace(TRACE_MASKT, "-> request()");
        ChatletResponse response = new ChatletResponse();
        Map inMap = this.bytesToMap((byte[])request.getProperty("com.ibm.hwmca.fw.fcs.impl.stream.FcsControlChatletServiceToken"));
        Map outMap = this.buildResponse(inMap);
        response.setProperty("com.ibm.hwmca.fw.fcs.impl.stream.FcsControlChatletServiceToken", this.mapToBytes(outMap));
        Trace.trace(TRACE_MASKT, "<- request()");
        return response;
    }

    public void setChatletServerPortal(ChatletServerPortal portal) {
        Trace.trace(TRACE_MASKT, "<> setChatletServerPortal()");
        this.portal = portal;
    }

    public ChatletServerPortal getChatletServerPortal() {
        Trace.trace(TRACE_MASKT, "<> getChatletServerPortal()");
        return this.portal;
    }

    public void destroy() {
        Trace.trace(TRACE_MASKT, "-> destroy()");
        Trace.trace(TRACE_MASKT, "<- destroy()");
    }
}

